# Deployment Checklist - Next Steps

## ✅ What You've Done:
- [x] Created PostgreSQL database on cPanel
- [x] Built the project locally (`npm run build`)

## 📋 Next Steps:

### Step 1: Get Database Connection Details
From your cPanel PostgreSQL database, note down:
- **Database Name:** `cpaneluser_peerpurse_db` (or similar)
- **Database User:** `cpaneluser_dbuser` (or similar)
- **Database Password:** (the one you set)
- **Host:** Usually `localhost` (or check your cPanel)
- **Port:** Usually `5432`

Your connection string will look like:
```
postgresql://cpaneluser_dbuser:your_password@localhost:5432/cpaneluser_peerpurse_db
```

### Step 2: Prepare Files for Upload
You need to upload these folders/files to cPanel:
- `.next/` (build output)
- `app/`
- `components/`
- `lib/`
- `prisma/`
- `node_modules/` (or install on server)
- `package.json`
- `package-lock.json`
- `server.js`
- `next.config.ts`
- `tsconfig.json`
- `tailwind.config.ts` (if exists)
- `postcss.config.mjs`
- `public/` folder

### Step 3: Upload to cPanel
1. Go to cPanel → File Manager
2. Navigate to your domain folder (usually `public_html` or your subdomain folder)
3. Upload all the files above
4. **OR** compress the entire `web/` folder and extract it on cPanel

### Step 4: Create .env File on Server
In your cPanel File Manager, create a `.env` file in the app root with:

```env
DATABASE_URL="postgresql://cpaneluser_dbuser:your_password@localhost:5432/cpaneluser_peerpurse_db"
ADMIN_EMAIL=admin@yourdomain.com
ADMIN_PASSWORD=your_secure_password
NEXTAUTH_SECRET=your-long-random-secret-at-least-32-characters
NODE_ENV=production
```

**Replace all values with your actual credentials!**

### Step 5: Install Dependencies on Server
Via SSH or cPanel Terminal:
```bash
cd /home/yourusername/public_html  # or your app path
npm install --production
npx prisma generate
```

### Step 6: Run Database Migrations
```bash
npx prisma migrate deploy
```

### Step 7: Set Up Node.js App in cPanel
1. Go to cPanel → "Node.js Selector" or "Setup Node.js App"
2. Create new application:
   - Application Root: your app directory
   - Application URL: your domain/subdomain
   - Application Startup File: `server.js`
   - Node.js Version: Latest LTS (18.x or 20.x)
3. Click "Run" or "Restart"

### Step 8: Test
- Visit your domain
- Test waitlist form
- Test admin login at `/admin/login`

