## Peerpurse — Landing + Admin

Tech: Next.js 14 App Router, TypeScript, Tailwind, Prisma (PostgreSQL), Iron Session.

### 1) Environment

Create `.env.local` in `web/`:

```env
DATABASE_URL=postgresql://user:password@localhost:5432/yourdb
ADMIN_EMAIL=admin@example.com
ADMIN_PASSWORD=securepassword
NEXTAUTH_SECRET=long-random-string
```

### 2) Setup

```bash
npm install
npx prisma generate
npx prisma migrate dev --name init
npm run dev
```

### 3) URLs

- Landing: `http://localhost:3000/`
- Admin Login: `http://localhost:3000/admin/login`
- Admin Dashboard: `http://localhost:3000/admin`

### Notes

- POST `/api/waitlist` saves entries; duplicate emails return 409.
- GET `/api/waitlist` requires admin session (login first).
