import { redirect } from "next/navigation";
import { getAdminSession } from "@/lib/session";
import AdminTable from "@/components/AdminTable";

export default async function AdminDashboardPage() {
    const session = await getAdminSession();
    if (!session.isLoggedIn) {
        redirect("/admin/login");
    }

    async function logout() {
        "use server";
        const session = await getAdminSession();
        session.destroy();
        redirect("/admin/login");
    }

    return (
        <div className="min-h-screen bg-white">
            <header className="border-b">
                <div className="max-w-6xl mx-auto px-6 py-4 flex items-center justify-between">
                    <h1 className="text-xl font-semibold">Waiting List</h1>
                    <form action={logout}>
                        <button className="rounded-md border border-gray-300 px-4 py-2 text-gray-700 hover:bg-gray-50">Logout</button>
                    </form>
                </div>
            </header>
            <main className="max-w-6xl mx-auto px-6 py-8">
                <AdminTable />
            </main>
        </div>
    );
}


