import { NextRequest, NextResponse } from "next/server";
import { getAdminSession } from "@/lib/session";

export async function POST(req: NextRequest) {
    const body = await req.json();
    const email = String(body?.email ?? "").trim();
    const password = String(body?.password ?? "").trim();

    const adminEmail = process.env.ADMIN_EMAIL;
    const adminPassword = process.env.ADMIN_PASSWORD;

    if (!adminEmail || !adminPassword) {
        return NextResponse.json({ error: "Server misconfigured" }, { status: 500 });
    }

    if (email === adminEmail && password === adminPassword) {
        const session = await getAdminSession();
        session.isLoggedIn = true;
        session.adminEmail = email;
        await session.save();
        return NextResponse.json({ ok: true });
    }

    return NextResponse.json({ error: "Invalid credentials" }, { status: 401 });
}


