"use client";
import { useState } from "react";
import Hero from "@/components/Hero";
import WaitlistForm from "@/components/WaitlistForm";
import Features from "@/components/Features";
import HowItWorks from "@/components/HowItWorks";
import AnimatedBackground from "@/components/AnimatedBackground";
import WaitlistModal from "@/components/WaitlistModal";

export default function Home() {
  const [modalOpen, setModalOpen] = useState(false);
  return (
    <div className="min-h-screen bg-white relative">
      <AnimatedBackground />
      <Hero onJoinClick={() => setModalOpen(true)} />
      <Features />
      <HowItWorks />
      {/* Keep inline form section for anchor compatibility but hide visually */}
      <div className="sr-only">
        <WaitlistForm />
      </div>
      <WaitlistModal open={modalOpen} onClose={() => setModalOpen(false)} />
      <footer className="border-t border-purple-100 bg-gradient-to-b from-white to-purple-50/30 backdrop-blur-xl">
        <div className="max-w-5xl mx-auto px-6 py-8 text-center">
          <p className="text-sm text-gray-600">
            © {new Date().getFullYear()} <span className="font-semibold text-[#6B21A8]">Peerpurse</span>. All rights reserved.
          </p>
        </div>
      </footer>
    </div>
  );
}
