"use client";
import { useEffect, useRef } from "react";

// Subtle animated particle background using canvas
export default function AnimatedBackground() {
    const ref = useRef<HTMLCanvasElement | null>(null);

    useEffect(() => {
        const canvas = ref.current;
        if (!canvas) return;
        const ctx = canvas.getContext("2d");
        if (!ctx) return;

        let raf = 0;
        const particles = Array.from({ length: 40 }).map(() => ({
            x: Math.random() * window.innerWidth,
            y: Math.random() * 400 + 50,
            r: Math.random() * 2 + 0.5,
            vx: (Math.random() - 0.5) * 0.3,
            vy: (Math.random() - 0.5) * 0.3,
        }));

        const resize = () => {
            canvas.width = window.innerWidth;
            canvas.height = 500;
        };
        resize();
        window.addEventListener("resize", resize);

        const loop = () => {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            for (const p of particles) {
                p.x += p.vx; p.y += p.vy;
                if (p.x < 0 || p.x > canvas.width) p.vx *= -1;
                if (p.y < 0 || p.y > canvas.height) p.vy *= -1;
                ctx.beginPath();
                ctx.arc(p.x, p.y, p.r, 0, Math.PI * 2);
                ctx.fillStyle = "rgba(107,33,168,0.12)"; // purple tint
                ctx.fill();
            }
            raf = requestAnimationFrame(loop);
        };
        loop();

        return () => { cancelAnimationFrame(raf); window.removeEventListener("resize", resize); };
    }, []);

    return (
        <div className="absolute inset-x-0 top-0 -z-20 h-[500px] overflow-hidden">
            <canvas ref={ref} className="h-full w-full" />
        </div>
    );
}


