"use client";
import { motion } from "framer-motion";
import { ShieldCheck, Landmark, CreditCard, LineChart } from "lucide-react";

const features = [
    { title: "Borrow From People You Trust", Icon: Landmark, desc: "Borrow from friends or family without the fear of asking or chasing repayment, PeerPurse handles the tracking, reminders, and repayment securely." },
    { title: "Smart & Automated Repayment", Icon: LineChart, desc: "Direct debit ensures repayments happen automatically , no stress, no embarrassment." },
    { title: "Seamless Bill Payments", Icon: CreditCard, desc: "Pay utilities and services in a few taps across providers." },
    { title: "Secure P2P Lending", Icon: ShieldCheck, desc: "Protected, compliant, and encrypted end-to-end." },
];

export default function Features() {
    return (
        <section className="relative py-24 bg-gradient-to-b from-white to-purple-50/20">
            <div className="max-w-7xl mx-auto px-6">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    viewport={{ once: true }}
                    transition={{ duration: 0.6 }}
                    className="text-center mb-16"
                >
                    <h2 className="text-4xl sm:text-5xl font-extrabold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">
                        Built for modern money
                    </h2>
                    <p className="mt-4 text-xl text-gray-600 max-w-2xl mx-auto">
                        Everything you need to move funds with confidence and security.
                    </p>
                </motion.div>

                <div className="grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
                    {features.map(({ title, Icon, desc }, i) => (
                        <motion.div
                            key={title}
                            initial={{ opacity: 0, y: 20 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            viewport={{ once: true, amount: 0.3 }}
                            whileHover={{ y: -8, scale: 1.02 }}
                            transition={{ duration: 0.4, delay: i * 0.1 }}
                            className="group relative rounded-3xl border border-purple-100/50 bg-white/80 backdrop-blur-xl p-6 shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden"
                        >
                            <div className="absolute inset-0 bg-gradient-to-br from-[#6B21A8]/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                            <div className="relative z-10">
                                <div className="flex h-14 w-14 items-center justify-center rounded-2xl bg-gradient-to-br from-[#6B21A8]/10 to-purple-100/50 text-[#6B21A8] group-hover:scale-110 transition-transform duration-300 shadow-md">
                                    <Icon size={26} strokeWidth={2} />
                                </div>
                                <h3 className="mt-6 text-xl font-bold text-gray-900 group-hover:text-[#6B21A8] transition-colors duration-300">
                                    {title}
                                </h3>
                                <p className="mt-3 text-sm leading-relaxed text-gray-600">
                                    {desc}
                                </p>
                            </div>
                        </motion.div>
                    ))}
                </div>
            </div>
        </section>
    );
}


