"use client";
import { motion } from "framer-motion";

export default function Hero({ onJoinClick }: { onJoinClick?: () => void }) {
    return (
        <section className="relative overflow-hidden w-full py-32 sm:py-40 bg-gradient-to-b from-white via-purple-50/30 to-white">
            {/* Enhanced animated gradient background */}
            <div className="pointer-events-none absolute inset-0 -z-10">
                <motion.div
                    animate={{
                        scale: [1, 1.1, 1],
                        opacity: [0.4, 0.5, 0.4],
                    }}
                    transition={{
                        duration: 8,
                        repeat: Infinity,
                        ease: "easeInOut",
                    }}
                    className="absolute -top-40 -left-32 h-96 w-96 rounded-full bg-gradient-to-br from-[#6B21A8]/50 via-purple-400/40 to-purple-300/30 blur-3xl"
                />
                <motion.div
                    animate={{
                        scale: [1, 1.15, 1],
                        opacity: [0.3, 0.4, 0.3],
                    }}
                    transition={{
                        duration: 10,
                        repeat: Infinity,
                        ease: "easeInOut",
                        delay: 1,
                    }}
                    className="absolute -bottom-40 -right-32 h-[28rem] w-[28rem] rounded-full bg-gradient-to-tr from-purple-300/40 via-[#6B21A8]/30 to-purple-200/20 blur-3xl"
                />
            </div>

            <div className="max-w-7xl mx-auto px-6 grid lg:grid-cols-2 gap-12 items-center">
                <div className="relative z-10">
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.6 }}
                        className="inline-block mb-4 px-4 py-1.5 rounded-full bg-[#6B21A8]/10 border border-[#6B21A8]/20"
                    >
                        <span className="text-sm font-semibold text-[#6B21A8]">🚀 Coming Soon</span>
                    </motion.div>
                    <motion.h1
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.7, delay: 0.1 }}
                        className="text-5xl sm:text-6xl lg:text-7xl font-extrabold tracking-tight bg-gradient-to-r from-gray-900 via-gray-800 to-gray-900 bg-clip-text text-transparent leading-tight"
                    >
                        Finance that moves at <span className="bg-gradient-to-r from-[#6B21A8] to-purple-600 bg-clip-text text-transparent">your speed</span>.
                    </motion.h1>
                    <motion.p
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.7, delay: 0.2 }}
                        className="mt-6 text-xl text-gray-600 max-w-xl leading-relaxed"
                    >
                        We’re building a modern financial platform that lets you access fast peer-to-peer loans, pay your bills effortlessly, and manage your finances securely — all in one app.
                    </motion.p>
                    <motion.button
                        initial={{ opacity: 0, y: 10 }}
                        animate={{ opacity: 1, y: 0 }}
                        whileHover={{ scale: 1.05 }}
                        whileTap={{ scale: 0.98 }}
                        transition={{ duration: 0.5, delay: 0.3 }}
                        onClick={onJoinClick}
                        className="mt-10 inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-[#6B21A8] to-purple-700 text-white px-8 py-4 text-lg font-semibold shadow-[0_10px_40px_-10px_rgba(107,33,168,0.6)] hover:shadow-[0_15px_50px_-10px_rgba(107,33,168,0.7)] transition-all duration-300"
                    >
                        Join the Waitlist
                        <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </motion.button>
                </div>

                {/* Enhanced mockup card with glassmorphism */}
                <motion.div
                    initial={{ opacity: 0, scale: 0.95, y: 30 }}
                    animate={{ opacity: 1, scale: 1, y: 0 }}
                    transition={{ duration: 0.8, delay: 0.2 }}
                    className="relative"
                >
                    <div className="absolute -inset-1 bg-gradient-to-r from-[#6B21A8]/20 via-purple-500/20 to-[#6B21A8]/20 rounded-3xl blur-xl opacity-75"></div>
                    <div className="relative rounded-3xl border border-white/80 bg-white/80 backdrop-blur-2xl shadow-2xl p-6 transform hover:scale-[1.02] transition-transform duration-300">
                        <div className="rounded-2xl bg-gradient-to-br from-white via-purple-50/50 to-purple-100/30 p-7 border border-purple-100/50">
                            <div className="flex items-center justify-between mb-4">
                                <div className="text-sm font-medium text-gray-600">Total Balance</div>
                                <div className="h-2 w-20 rounded-full bg-gradient-to-r from-purple-200 to-purple-300"></div>
                            </div>
                            <div className="mt-4 text-4xl font-bold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">₦12,480.00</div>
                            <div className="mt-8 grid grid-cols-3 gap-4">
                                <motion.div
                                    whileHover={{ scale: 1.05, y: -2 }}
                                    className="rounded-xl bg-gradient-to-br from-white to-purple-50/80 p-4 shadow-md border border-purple-100/50"
                                >
                                    <div className="text-xs font-medium text-gray-500 mb-1">P2P</div>
                                    <div className="font-bold text-green-600">+₦820</div>
                                </motion.div>
                                <motion.div
                                    whileHover={{ scale: 1.05, y: -2 }}
                                    className="rounded-xl bg-gradient-to-br from-white to-purple-50/80 p-4 shadow-md border border-purple-100/50"
                                >
                                    <div className="text-xs font-medium text-gray-500 mb-1">Bills</div>
                                    <div className="font-bold text-red-600">-₦120</div>
                                </motion.div>
                                <motion.div
                                    whileHover={{ scale: 1.05, y: -2 }}
                                    className="rounded-xl bg-gradient-to-br from-white to-purple-50/80 p-4 shadow-md border border-purple-100/50"
                                >
                                    <div className="text-xs font-medium text-gray-500 mb-1">Credit</div>
                                    <div className="font-bold text-[#6B21A8]">A+</div>
                                </motion.div>
                            </div>
                        </div>
                    </div>
                </motion.div>
            </div>
        </section>
    );
}


