"use client";
import { motion } from "framer-motion";

const steps = [
    {
        title: "Join the waitlist",
        desc: "Tell us where to reach you. Early users get priority access.",
        icon: "📝",
    },
    {
        title: "Get onboarded",
        desc: "Verify your profile and connect your preferred payment method.",
        icon: "✅",
    },
    {
        title: "Move money with confidence",
        desc: "Lend, borrow, and pay bills—fast, secure, and transparent.",
        icon: "💸",
    },
];

export default function HowItWorks() {
    return (
        <section className="relative py-24 bg-white">
            <div className="max-w-5xl mx-auto px-6">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    viewport={{ once: true }}
                    transition={{ duration: 0.6 }}
                    className="text-center mb-16"
                >
                    <h2 className="text-4xl sm:text-5xl font-extrabold bg-gradient-to-r from-gray-900 to-gray-700 bg-clip-text text-transparent">
                        How it works
                    </h2>
                    <p className="mt-4 text-xl text-gray-600">
                        Simple steps to get started in minutes.
                    </p>
                </motion.div>
                <div className="relative">
                    {/* Connecting line */}
                    <div className="hidden lg:block absolute left-12 top-0 bottom-0 w-0.5 bg-gradient-to-b from-purple-200 via-[#6B21A8]/30 to-purple-200"></div>
                    <div className="space-y-8">
                        {steps.map((s, i) => (
                            <motion.div
                                key={s.title}
                                initial={{ opacity: 0, x: -20 }}
                                whileInView={{ opacity: 1, x: 0 }}
                                viewport={{ once: true, amount: 0.3 }}
                                whileHover={{ x: 8, scale: 1.02 }}
                                transition={{ duration: 0.5, delay: i * 0.15 }}
                                className="relative flex items-start gap-6 group"
                            >
                                {/* Step number circle */}
                                <div className="relative z-10 flex-shrink-0">
                                    <div className="flex h-16 w-16 items-center justify-center rounded-2xl bg-gradient-to-br from-[#6B21A8] to-purple-700 text-white text-2xl font-bold shadow-lg group-hover:scale-110 transition-transform duration-300 border-4 border-white">
                                        <span className="text-3xl">{s.icon}</span>
                                    </div>
                                    {i < steps.length - 1 && (
                                        <div className="lg:hidden absolute left-1/2 top-full w-0.5 h-8 bg-gradient-to-b from-purple-300 to-transparent -translate-x-1/2"></div>
                                    )}
                                </div>
                                {/* Content card */}
                                <div className="flex-1 rounded-3xl border border-purple-100/50 bg-gradient-to-br from-white to-purple-50/30 p-6 shadow-lg hover:shadow-xl transition-all duration-300 group-hover:border-[#6B21A8]/30">
                                    <h3 className="text-2xl font-bold text-gray-900 group-hover:text-[#6B21A8] transition-colors duration-300">
                                        {s.title}
                                    </h3>
                                    <p className="mt-2 text-gray-600 leading-relaxed">
                                        {s.desc}
                                    </p>
                                </div>
                            </motion.div>
                        ))}
                    </div>
                </div>
            </div>
        </section>
    );
}


