"use client";
import { useState } from "react";
import { useRouter } from "next/navigation";

export default function LoginForm() {
    const router = useRouter();
    const [email, setEmail] = useState("");
    const [password, setPassword] = useState("");
    const [loading, setLoading] = useState(false);
    const [error, setError] = useState<string | null>(null);

    async function onSubmit(e: React.FormEvent) {
        e.preventDefault();
        setLoading(true);
        setError(null);
        const payload = { email: email.trim(), password: password.trim() };
        const res = await fetch("/api/auth/login", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(payload),
        });
        setLoading(false);
        if (res.ok) {
            router.push("/admin");
        } else {
            const data = await res.json().catch(() => ({}));
            setError(data?.error || "Invalid credentials");
        }
    }

    return (
        <form onSubmit={onSubmit} className="w-full max-w-sm rounded-lg border p-6 shadow-sm">
            <h1 className="text-2xl font-semibold text-gray-900">Admin Login</h1>
            <p className="text-gray-600 mt-1">Use credentials from your environment.</p>
            <div className="mt-6 space-y-4">
                <div>
                    <label className="block text-sm font-medium text-gray-700">Email</label>
                    <input
                        type="email"
                        value={email}
                        onChange={(e) => setEmail(e.target.value)}
                        className="mt-1 w-full rounded-md border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[#6B21A8]"
                    />
                </div>
                <div>
                    <label className="block text-sm font-medium text-gray-700">Password</label>
                    <input
                        type="password"
                        value={password}
                        onChange={(e) => setPassword(e.target.value)}
                        className="mt-1 w-full rounded-md border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[#6B21A8]"
                    />
                </div>
                {error && <p className="text-sm text-red-600">{error}</p>}
                <button
                    type="submit"
                    disabled={loading}
                    className="w-full rounded-md bg-[#6B21A8] text-white py-2.5 font-medium hover:opacity-95 disabled:opacity-60"
                >
                    {loading ? "Logging in..." : "Login"}
                </button>
            </div>
        </form>
    );
}


