import { getIronSession, IronSession } from "iron-session";
import { cookies } from "next/headers";

export type AdminSession = {
    isLoggedIn: boolean;
    adminEmail?: string;
};

const sessionOptions = {
    password: process.env.NEXTAUTH_SECRET || "dev-secret-change-me-please-very-long",
    cookieName: "peerpurse_admin_session",
    cookieOptions: {
        secure: process.env.NODE_ENV === "production",
        sameSite: "lax" as const,
    },
};

export async function getAdminSession(): Promise<IronSession<AdminSession>> {
    const cookieStore = await cookies();
    return getIronSession<AdminSession>(cookieStore, sessionOptions);
}


