import { z } from "zod";

export const waitlistSchema = z.object({
    name: z.string().min(2, "Full name is required"),
    email: z.string().email("Invalid email address"),
    phone: z
        .string()
        .min(7, "Phone number is required")
        .regex(/^[+0-9\-()\s]+$/, "Invalid phone number"),
});

export type WaitlistInput = z.infer<typeof waitlistSchema>;


